
IF OBJECT_ID('P_EXP_CTB_MOV_VENDAS_CONTABIL_CHEQUE_PRAZO') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EXP_CTB_MOV_VENDAS_CONTABIL_CHEQUE_PRAZO
	END
 
GO
 
CREATE PROCEDURE P_EXP_CTB_MOV_VENDAS_CONTABIL_CHEQUE_PRAZO(@CD_EMP		INT,
														    @CD_FILIAL	INT,
														    @DT_INI		DATETIME,
														    @DT_FIM		DATETIME,
														    @FLAG_LIMPAR INT = 0)		
	

WITH ENCRYPTION AS  
SET NOCOUNT ON;
BEGIN TRY
BEGIN
	
    DECLARE @RS_CD_EMP				INT
    DECLARE @RS_CD_FILIAL			INT 
    DECLARE @RS_DT_EMI				DATETIME
    DECLARE @RS_FLAG_ORIG_VENDA		VARCHAR(10) 
    DECLARE @RS_CD_CUSTODIA			INT
    DECLARE @RS_VLR_CUSTODIA			MONEY
    DECLARE @RS_VLR_ACERTO			MONEY
    DECLARE @RS_CD_BC				INT
    DECLARE @RS_CD_CNT				VARCHAR(50)
    DECLARE @RS_DS_BC				VARCHAR(50)
    DECLARE @RS_FLAG_NAO_EXISTE_LANCTO_CHQS_EM_CUSTODIA	INT
	
    DECLARE @RET_CD_CTB_CNT			VARCHAR(100)
    DECLARE @RET_CD_CTB_CNT_RED		INT	
    DECLARE @RET_DS_CNT				VARCHAR(100)
    DECLARE @RET_NR_CNT				VARCHAR(50)
    DECLARE @RET_TP_CNT				INT
    DECLARE @RET_TITULAR_CNT			VARCHAR(200)
    DECLARE @RET_RZ_CLI				VARCHAR(200)
    
    DECLARE @CD_MOVIMENTO			INT
    DECLARE @MOVIMENTO				VARCHAR(50)
    DECLARE @OPERACAO				VARCHAR(50)
    DECLARE @OPERACAO_DEBITO			VARCHAR(50)
    DECLARE @HIST					VARCHAR(250)
    DECLARE @NR_CONTROLE				VARCHAR (12)
     
	------------------------------------------------------------------------------------------------------------------------------
	--CRIANDO A TABELA TEMPORARIA ##CTB_EXP_MOV
	------------------------------------------------------------------------------------------------------------------------------
	EXEC P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV @FLAG_LIMPAR

	DECLARE RS_RESULT
	CURSOR FOR 								
		SELECT 
			T.CD_EMP,
			T.CD_FILIAL,
			T.DT_EMI,
			T.FLAG_ORIG_VENDA,
			T.CD_CUSTODIA,
			T.VLR_CUSTODIA,
			T.VLR_ACERTO,
			T.CD_BC,
			T.CD_CNT,
			T.DS_BC,
			T.FLAG_NAO_EXISTE_LANCTO_CHQS_EM_CUSTODIA
		FROM UFD_EXP_CTB_MOV_CHQ_PRAZO(@CD_EMP, @CD_FILIAL, @DT_INI, @DT_FIM) T		
		ORDER BY
			T.CD_EMP,
			T.CD_FILIAL,
			T.DT_EMI

		--Abrindo cursor
		OPEN RS_RESULT
		
		--Atribuindo valores do select nas variveis
		FETCH NEXT FROM RS_RESULT INTO 
				@RS_CD_EMP, 
				@RS_CD_FILIAL,		
				@RS_DT_EMI,
				@RS_FLAG_ORIG_VENDA,
				@RS_CD_CUSTODIA,
				@RS_VLR_CUSTODIA,
				@RS_VLR_ACERTO,
				@RS_CD_BC,
				@RS_CD_CNT,
				@RS_DS_BC,
				@RS_FLAG_NAO_EXISTE_LANCTO_CHQS_EM_CUSTODIA
								

		--Iniciando lao
		WHILE @@FETCH_STATUS = 0
			BEGIN	
				
				IF @RS_FLAG_NAO_EXISTE_LANCTO_CHQS_EM_CUSTODIA = 1
					BEGIN
						SET @RET_CD_CTB_CNT			= ''
						SET @RET_CD_CTB_CNT_RED		= 0
						SET @RET_DS_CNT				= ''
						SET @RET_NR_CNT				= ''
						SET @RET_TP_CNT				= 0
						SET @RET_TITULAR_CNT		= ''
					END
				ELSE
					BEGIN
						SELECT 							
							@RET_CD_CTB_CNT			= CD_CTB_CNT,
							@RET_CD_CTB_CNT_RED		= CD_CTB_CNT_RED,
							@RET_DS_CNT				= DS_CNT,
							@RET_NR_CNT				= NR_CNT,
							@RET_TP_CNT				= TP_CNT,
							@RET_TITULAR_CNT		= TITULAR_CNT
						FROM UFD_BUSCA_CONTA_BC_CONTAS(@CD_EMP, @RS_CD_CNT)					
					END
							
				---------------------------------------------------------------------------------------------------------------------------
				--CHEQUES A PRAZO - Ctb_Cnt_Cheques_Prazo / CNT BANC
				---------------------------------------------------------------------------------------------------------------------------				
				
				--===== Tipos de Registros de movimento de vendas para codigo de Controle usado no  Nmero de Documento ===================
				
				--1 - vendas dinheiro, recargas no fiscal, cartao, convnio						  
				--2 - vendas icms
				--3 - vendas confins 
				--4 - vendas pis 
				--5 - vendas custo
				
								
				SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
								RIGHT('00'+ CAST( DAY( @RS_DT_EMI) AS VARCHAR),2) + 
								 RIGHT('00'+  CAST( MONTH(@RS_DT_EMI) AS VARCHAR),2) + 
								  RIGHT('00'+ CAST( YEAR(@RS_DT_EMI)AS VARCHAR),2) + '021'  -- 02 CD_MOVIMENTO 01 tipo de registro 
								  
			    --===========================================================================================================================

				SELECT  
						@CD_MOVIMENTO		= (CASE WHEN @RS_FLAG_ORIG_VENDA = 'SIM' THEN 2 ELSE 5 END),
						@MOVIMENTO			= (CASE WHEN @RS_FLAG_ORIG_VENDA = 'SIM' THEN 'MOVIMENTO DE VENDAS' ELSE 'VENDAS - DEBITO' END),
						@OPERACAO_DEBITO	= (CASE WHEN @RS_FLAG_ORIG_VENDA = 'SIM' THEN 'MOVIMENTO RECEBTO CHEQUES' ELSE 'RECEBTO CHEQUES - DEBITO' END),
						@HIST				= (CASE WHEN @RS_FLAG_NAO_EXISTE_LANCTO_CHQS_EM_CUSTODIA = 0 THEN
													(CASE WHEN @RS_FLAG_ORIG_VENDA = 'SIM' THEN
														'VALOR REF. VENDAS - CHEQUE A PRAZO ' + @RS_DS_BC
													 ELSE
														'VALOR REF. RECEBTO DIVERSOS - CHEQUE A PRAZO ' + @RS_DS_BC
													 END)
											   ELSE
													(CASE WHEN @RS_FLAG_ORIG_VENDA = 'SIM' THEN
														'VALOR REF. VENDAS - CHEQUE A PRAZO'
													 ELSE
														'VALOR REF. RECEBTO DIVERSOS - CHEQUE A PRAZO'
													 END)											   
											   END)             
						SET @HIST = REPLACE (@HIST,'	',' ')
												
				INSERT INTO ##CTB_EXP_MOV  

				    (CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
				    CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
				    VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
				    ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


					SELECT									   
							    @RS_CD_EMP					,								--CD_EMP
								@CD_FILIAL					,								--CD_FILIAL_EXPORT
								@RS_CD_FILIAL				,								--CD_FILIAL
								@CD_MOVIMENTO				,								--CODIGO DO MOVIMENTO
								@MOVIMENTO					,								--MOVIMENTO			
								''							,								--OPERACAO
								@OPERACAO_DEBITO			,								--OPERACAO_DEBITO                					
								0							,								--CD_CNT_RED_CREDITO
								''							,								--CD_CNT_CREDITO
								@RET_CD_CTB_CNT_RED			,								--CD_CNT_RED_DEBITO
								@RET_CD_CTB_CNT				,								--CD_CNT_DEBITO								
								@RS_DT_EMI					,								--DT_MOV
								@HIST						,								--HIST
								ROUND(@RS_VLR_CUSTODIA,2)	,								--VLR_LANC
								'D'							,								--TP_TRANSA
								0 			,												--RATEIO_CENTRO_CUSTO
								'' 			,												--DS_CENTRO_CUSTO
								0 			,												--CNT_CENTRO_CUSTO
								0 			,												--VLR_CENTRO_CUSTO											
								--(CASE WHEN @RS_FLAG_NAO_EXISTE_LANCTO_CHQS_EM_CUSTODIA = 1 THEN 'FILIAIS'	ELSE 'CNT BANC'	END), --ORIG_CONTA
								--(CASE WHEN @RS_FLAG_NAO_EXISTE_LANCTO_CHQS_EM_CUSTODIA = 1 THEN 2			ELSE @RS_CD_CNT	END), --COD_CONTA
								'FILIAIS'                                                     ORIG_CONTA,
								 2                                                            COD_CONTA,
								OBJECT_NAME(@@PROCID)										--NM_PROCEDURE
								, 'D' AS TIPO_LANCTO
                                , 0 AS CD_EVENTO
								, 0  AS NR_DP
								, 0  AS ANO
								, @NR_CONTROLE AS NR_DOC
								, 0 AS CD_BC_LANC;	
 
			
			--Atribuindo valores do select nas variveis
			FETCH NEXT FROM RS_RESULT INTO 
					@RS_CD_EMP, 
					@RS_CD_FILIAL,		
					@RS_DT_EMI,
					@RS_FLAG_ORIG_VENDA,
					@RS_CD_CUSTODIA,
					@RS_VLR_CUSTODIA,
					@RS_VLR_ACERTO,
					@RS_CD_BC,
					@RS_CD_CNT,
					@RS_DS_BC,
					@RS_FLAG_NAO_EXISTE_LANCTO_CHQS_EM_CUSTODIA
			
			END

		CLOSE RS_RESULT
		DEALLOCATE RS_RESULT
		
END

END TRY
BEGIN CATCH
	CLOSE RS_RESULT
	DEALLOCATE RS_RESULT	

	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;	
END CATCH			